---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：5-Pkgモード（pkg>）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Pkg.jlのコマンド一覧**: 具体的な対応コマンドリストの確認が必要
  2. **REPLExtの詳細動作**: PkgCompletionProviderの具体的な実装確認が必要
  3. **Project.toml/Manifest.toml更新仕様**: Pkg操作による具体的なファイル更新内容の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/REPL/src/Pkg_beforeload.jl` 1-122行 - Pkg遅延ロード関連
- E-02: `stdlib/REPL/src/REPL.jl` 1334-1359行 - ダミーPkgモード設定
- E-03: `stdlib/REPL/src/REPL.jl` 114行 - PKG_PROMPT定数
- E-04: `stdlib/REPL/src/REPL.jl` 1200-1228行 - mode_keymap()
- E-05: `docs/code-to-docs/画面遷移図.md` - 画面遷移定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ]キーで行頭入力時にPkgモードに遷移する | E-02, E-05 | ○ |
| C-02 | プロンプトがPkg_promptf()で動的生成される | E-01 (93-122行), E-02 (1334行) | ○ |
| C-03 | 初回実行時にload_pkg()でPkg.jlが遅延ロードされる | E-01 (6行), E-02 (1344行) | ○ |
| C-04 | Pkg_pkgidがUUID付きで定義されている | E-01 (5行) | ○ |
| C-05 | load_pkg()がBase.require_stdlibを呼び出す | E-01 (6行) | ○ |
| C-06 | on_enterでPkgCompletionProviderモードを検索して遷移する | E-02 (1346-1355行) | ○ |
| C-07 | プロジェクト名がProject.tomlのnameフィールドから取得される | E-01 (67-70行) | ○ |
| C-08 | 30文字を超えるプロジェクト名は27文字+...に切り詰められる | E-01 (110-111行) | ○ |
| C-09 | ベースプロジェクトとサブプロジェクトでパスプレフィックスが追加される | E-01 (103-113行) | ○ |
| C-10 | sticky=trueでコマンド実行後もPkgモード維持 | E-02 (1359行) | ○ |
| C-11 | ダミーモードではEmptyCompletionProviderが使用される | E-02 (1339行) | ○ |
| C-12 | BackspaceまたはCtrl+CでJuliaプロンプトに戻る | E-04, E-05 | ○ |
| C-13 | 履歴プロバイダーにpkgモードが登録される | E-02 (1369行) | ○ |
| C-14 | find_project_file()でプロジェクトファイルを検出する | E-01 (24-45行) | ○ |
| C-15 | find_root_base_project()でルートプロジェクトを検出する | E-01 (47-54行) | ○ |
| C-16 | 5種類の関連機能が存在する | E-06 | ○ |
| C-17 | Pkg.jlのadd/rm/update/resolve/instantiate等のコマンドが実行可能 | **根拠なし** | △ |
| C-18 | Project.toml/Manifest.tomlの更新が行われる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: Pkg.jlの具体的なコマンド一覧はPkg.jl本体のソースコードを確認する必要がある。REPL側のコードからはPkgコマンドの詳細は確認できない。
  - 候補：`stdlib/Pkg/src/` 内のREPL拡張コード
- C-18: Project.toml/Manifest.tomlの更新仕様はPkg.jlの内部実装に依存する。REPLモジュール側からは直接確認できない。
  - 候補：`stdlib/Pkg/src/Types.jl` / `stdlib/Pkg/src/Operations.jl`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Pkg操作はファイルシステムとネットワークへのアクセスを伴う
- 1: 中リスク - 遅延ロードによるダミーモード→本体モード切替の正確な動作確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ダミーモードから本体モードへの自動切替フローが正しいか確認
- [ ] Pkg_promptf()のプロジェクト名表示ロジックが正しいか確認
- [ ] Pkg.jlの具体的なコマンド一覧を補完する必要があるか確認
- [ ] Project.toml/Manifest.toml更新仕様の詳細を補完する必要があるか確認
